require( "scripts/style.lua" );

EditorHeaderFont = {
  proportionalFont,
  14,
  BorderColor
};

EditorSmallHeaderFont = {
  proportionalFont,
  10,
  BorderColor
};

EditorTextEditFont = {
  proportionalFont,
  14,
  BorderColor
};

function MakeCareerWindow()
	return Group {
		FillWindow
		{
			x=105,
			y= 0,
			w= 585,
			h = 110,
			name = "careergroup",
			r = 0.85,
			g = 0.75,
			b = 0.75,
				
				
			Window
			{
				name = "careerlevelgroup",
				x = 0, y = 0, w=kMax, h=kMax,
				
				Text
				{
					font = EditorHeaderFont,
					name = "level",
					x=15,y=10,w=40,h=20,
					flags = kHAlignCenter + kVAlignTop,
					label = "level"
				};
				
				Text
				{
					font = EditorHeaderFont,
					name = "levelval",
					x=15,y=20,w=40,h=20,
					flags = kHAlignCenter + kVAlignTop,
					label = "1"
				};
				
				Button
				{
					x = 5,
					y = 20,
					name = "levelleft",
					graphics = LeftArrowGraphics,
					type = kPush,
					scale = 0.25,
					command = 
						function() 
							IncrementLevel(-1, false);
						end	
				},
				
				Button
				{
					x = 55,
					y = 20,
					name = "levelright",
					graphics = LeftArrowGraphics,
					hflip = true,
					type = kPush,
					scale = 0.25,
					command = 
						function() 
							IncrementLevel(1, false);
						end	
				},
				
				Text
				{
					font = EditorHeaderFont,
					name = "restaurant",
					x=15,y=40,w=80,h=20,
					flags = kHAlignCenter + kVAlignTop,
					label = "le_restaurant"
				};
				
				Text
				{
					font = EditorHeaderFont,
					name = "careerrestaurantval",
					x=15,y=55,w=80,h=20,
					flags = kHAlignCenter + kVAlignTop,
					label = "1"
				};
				
				Button
				{
					x = 5,
					y = 55,
					name = "restaurantleft",
					graphics = LeftArrowGraphics,
					type = kPush,
					scale = 0.25,
					command = 
						function() 
							IncrementRestaurant(-1);
						end	
				},
				
				Button
				{
					x = 95,
					y = 55,
					name = "restaurantright",
					graphics = LeftArrowGraphics,
					hflip = true,
					type = kPush,
					scale = 0.25,
					command = 
						function() 
							IncrementRestaurant(1);
						end	
				},				
			};			
			
			Window
			{
				name = "bonuslevelgroup",
				x = 0, y = 0, w=kMax, h=kMax,	
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "goal",
				x=160,y=10,w=60,h=20,
				flags = kHAlignLeft + kVAlignTop,
				label = "le_goal"
			};
			FillWindow
			{
				x=200,
				y=10,
				w=40,
				h = 20,
				r = 0.8,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "goalval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "expert",
				x=160,y=40,w=60,h=20,
				flags = kHAlignLeft + kVAlignTop,
				label = "le_expert",
				
			};
			
			FillWindow
			{
				x=200,
				y=40,
				w=40,
				h = 20,
				r = 0.8,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "expertval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "leavepenalty",
				x=130,y=70,w=120,h=20,
				flags = kHAlignLeft + kVAlignTop,
				label = "le_leavepenalty",
				
			};
			
			FillWindow
			{
				x=200,
				y=70,
				w=40,
				h = 20,
				r = 0.8,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "leavepenaltyval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "snackchance",
				x=250,y=10,w=100,h=20,
				flags = kHAlignLeft + kVAlignTop,
				label = "le_snackchance"
			};
			
			FillWindow
			{
				x=320,
				y=10,
				w=40,
				h = 20,
				r = 0.8,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "snackchanceval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "gridrowslabel",
				x=260,y=70,w=100,h=20,
				flags = kHAlignLeft + kVAlignTop,
				label = "le_gridrows"
			};
			
			FillWindow
			{
				x=300,
				y=70,
				w=30,
				h = 20,
				r = 0.8,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "gridrows",
					x=5,y=0,w=kMax-5,h=kMax,
					length=2					
				};
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "gridcolslabel",
				x=335,y=70,w=100,h=20,
				flags = kHAlignLeft + kVAlignTop,
				label = "le_gridcols"
			};
			
			FillWindow
			{
				x=380,
				y=70,
				w=30,
				h = 20,
				r = 0.8,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "gridcols",
					x=5,y=0,w=kMax-5,h=kMax,
					length=2					
				};
			};
			
			Window
			{
				name = "careerlayoutgroup",
				x = 250,
				y = 40,
				
				Text
				{
					font = EditorHeaderFont,
					name = "doodle",
					x=0,y=3,w=60,h=20,
					flags = kHAlignLeft + kVAlignTop,
					label = "le_doodle",
					
				};
				
				FillWindow
				{
					x=50,
					y=0,
					w= 280,
					h = 20,
					r = 0.8,
					g = 0.5,
					b = 0.5,
					
					TextEdit
					{
						font = EditorTextEditFont,
						name = "doodleval",
						x=5,y=3,w=kMax,h=kMax,
						length=80
					};
				};
			};
			

			
			Button
			{
				x=480,
				y=70,
				font = EditorHeaderFont,
				graphics = SolidButtonGraphics,
				name="customers",
				label="le_customers",
				type = kPush,
				command=
					function()
						DoModal("scripts/leveleditor/careermode.lua");
					end
			},
			
			
			
		};
	}
end

function MakeLevelTweaksWindow()
	return Group {
		FillWindow
		{
			name="leveltweaks",
			x=700,
			y= 5,
			w= 100,
			h = 320,
			r = 0.75,
			g = 0.65,
			b = 0.75,
	

			
			Button
			{
				x = 5,
				y = 0,
				w = 90,
				name = "flashlight",
				label= "le_flashlight",
				font = EditorSmallHeaderFont,
				flags = kHAlignRight + kVAlignBottom,
				graphics = CheckboxButtonGraphics,
				type = kToggle,	
				xoffset = 0,
				yoffset = 0,
				scale = 0.5,
				command = 
					function() 
						--ToggleStation(1);
					end					
			},
			
			Button
			{
				x = 5,
				y = 25,
				w = 90,
				name = "startdirty",
				label= "le_startdirty",
				font = EditorSmallHeaderFont,
				flags = kHAlignRight + kVAlignBottom,
				graphics = CheckboxButtonGraphics,
				type = kToggle,	
				xoffset = 0,
				yoffset = 0,
				scale = 0.5,
				command = 
					function() 
						--ToggleStation(1, 0);
					end					
			},
			
			Button
			{
				x = 5,
				y = 50,
				w = 90,
				name = "mustcolor",
				label= "le_mustcolor",
				font = EditorSmallHeaderFont,
				flags = kHAlignRight + kVAlignBottom,
				graphics = CheckboxButtonGraphics,
				type = kToggle,	
				xoffset = 0,
				yoffset = 0,
				scale = 0.5,
				command = 
					function() 
						--ToggleStation(1,0);
					end					
			},			
			
			Text
			{
				x = 5,
				y = 90,
				w = 90,
				h = 20,
				label= "le_4handlife",
				font = EditorSmallHeaderFont,
				flags = kHAlignLeft + kVAlignBottom
			},
			
			FillWindow
			{

				x=60,
				y= 95,
				w= 40,
				h = 15,
				r = 0.5,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "handlifeval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				x = 5,
				y = 115,
				w = 90,
				h = 20,
				label= "le_4handavail",
				font = EditorSmallHeaderFont,
				flags = kHAlignLeft + kVAlignBottom
			},
			
			FillWindow
			{

				x=60,
				y= 120,
				w= 40,
				h = 15,
				r = 0.5,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "handavailval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			

			
			Text
			{
				x = 5,
				y = 135,
				w = 90,
				h = 20,
				name = "shakefreq",
				label= "le_shakefreq",
				font = EditorSmallHeaderFont,
				flags = kHAlignLeft + kVAlignBottom
			},
			
			FillWindow
			{

				x=60,
				y= 140,
				w= 40,
				h = 15,
				r = 0.5,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "shakefreqval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				x = 5,
				y = 160,
				w = 90,
				h = 20,
				name = "shakespill",
				label= "le_shakespill",
				font = EditorSmallHeaderFont,
				flags = kHAlignLeft + kVAlignBottom
			},
			
			FillWindow
			{
				x=60,
				y= 165,
				w= 40,
				h = 15,
				r = 0.5,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "shakespillval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				x = 5,
				y = 185,
				w = 90,
				h = 20,
				name = "shakelength",
				label= "le_shakelength",
				font = EditorSmallHeaderFont,
				flags = kHAlignLeft + kVAlignBottom
			},
			
			FillWindow
			{
				x=60,
				y= 190,
				w= 40,
				h = 15,
				r = 0.5,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "shakelengthval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				x = 5,
				y = 210,
				w = 90,
				h = 20,
				name = "dashbar",
				label= "le_dashbar",
				font = EditorSmallHeaderFont,
				flags = kHAlignLeft + kVAlignBottom
			},
			
			FillWindow
			{
				x=60,
				y= 215,
				w= 40,
				h = 15,
				r = 0.5,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "dashbarval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				x = 5,
				y = 235,
				w = 90,
				h = 20,
				name = "dashbarlength",
				label= "le_dashbarlength",
				font = EditorSmallHeaderFont,
				flags = kHAlignLeft + kVAlignBottom
			},
			
			FillWindow
			{
				x=60,
				y= 240,
				w= 40,
				h = 15,
				r = 0.5,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "dashbarlengthval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				x = 5,
				y = 260,
				w = 90,
				h = 20,
				name = "dashbaravail",
				label= "le_dashbaravail",
				font = EditorSmallHeaderFont,
				flags = kHAlignLeft + kVAlignBottom
			},
			
			FillWindow
			{
				x=60,
				y= 265,
				w= 40,
				h = 15,
				r = 0.5,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "dashbaravailval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
		};
	}
end

function MakeBattleModeWindow()
	return Group {
		FillWindow
		{
			name="battlemodewin",
			x=700,
			y= 370,
			w= 100,
			h = 150,
			r = 0.75,
			g = 0.75,
			b = 0.85,
			
			
	
			BeginGroup();

			
			Button
			{
				x = 5,
				y = 10,
				w = 90,
				name = "ai_none",
				label= "le_noai",
				font = EditorSmallHeaderFont,
				flags = kHAlignRight + kVAlignBottom,
				graphics = CheckboxButtonGraphics,
				type = kRadio,	
				xoffset = 0,
				yoffset = 0,
				scale = 0.5				
			},
			
			Button
			{
				x = 5,
				y = 35,
				w = 90,
				name = "ai_coop",
				label= "le_aicooperative",
				font = EditorSmallHeaderFont,
				flags = kHAlignRight + kVAlignBottom,
				graphics = CheckboxButtonGraphics,
				type = kRadio,	
				xoffset = 0,
				yoffset = 0,
				scale = 0.5				
			},
			
			Button
			{
				x = 5,
				y = 60,
				w = 90,
				name = "ai_comp",
				label= "le_aicompetitive",
				font = EditorSmallHeaderFont,
				flags = kHAlignRight + kVAlignBottom,
				graphics = CheckboxButtonGraphics,
				type = kRadio,	
				xoffset = 0,
				yoffset = 0,
				scale = 0.5				
			},
			
			
			BeginGroup();
			
			Button
			{
				x = 5,
				y = 85,
				w = 90,
				name = "table_open",
				label= "le_tableopen",
				font = EditorSmallHeaderFont,
				flags = kHAlignRight + kVAlignBottom,
				graphics = CheckboxButtonGraphics,
				type = kRadio,	
				xoffset = 0,
				yoffset = 0,
				scale = 0.5				
			},
			
			Button
			{
				x = 5,
				y = 110,
				w = 90,
				name = "table_assigned",
				label= "le_tableassigned",
				font = EditorSmallHeaderFont,
				flags = kHAlignRight + kVAlignBottom,
				graphics = CheckboxButtonGraphics,
				type = kRadio,	
				xoffset = 0,
				yoffset = 0,
				scale = 0.5				
			},
			
			
			
			
			
		};
	}
end

function MakeEndlessWindow()
	return Group {
		FillWindow
		{
			x=125,
			y= 0,
			w= 675,
			h = 100,
			name = "endlessgroup",
			r = 0.75,
			g = 0.75,
			b = 0.75,
				
			Text
			{
				font = EditorHeaderFont,
				name = "endlesslevel",
				x=25,y=5,w=60,h=20,
				flags = kHAlignLeft + kVAlignTop,
				label = "level"
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "endlesslevelval",
				x=33,y=20,w=20,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = "1"
			};
			
			Button
			{
				x = 5,
				y = 20,
				name = "endlesslevelleft",
				graphics = LeftArrowGraphics,
				type = kPush,
				scale = 0.25,
				command = 
					function() 
						IncrementLevel(-1, false);
					end	
			},
			
			Button
			{
				x = 55,
				y = 20,
				name = "endlesslevelright",
				graphics = LeftArrowGraphics,
				hflip = true,
				type = kPush,
				scale = 0.25,
				command = 
					function() 
						IncrementLevel(1, false);
					end	
			},
			
			Text
			{
				font = EditorHeaderFont,
				name = "endlessrestaurant",
				x=15,y=50,w=80,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = "le_restaurant"
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "endlessrestaurantval",
				x=15,y=70,w=80,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = "1"
			};
			
			Button
			{
				x = 5,
				y = 70,
				name = "endlessrestaurantleft",
				graphics = LeftArrowGraphics,
				type = kPush,
				scale = 0.25,
				command = 
					function() 
						IncrementRestaurant(-1);
					end	
			},
			
			Button
			{
				x = 95,
				y = 70,
				name = "endlessrestaurantright",
				graphics = LeftArrowGraphics,
				hflip = true,
				type = kPush,
				scale = 0.25,
				command = 
					function() 
						IncrementRestaurant(1);
					end	
			},
			
			Text
			{
				font = EditorHeaderFont,
				name = "endlessstars",
				x=85,y=10,w=60,h=20,
				flags = kHAlignRight+ kVAlignTop,
				label = "le_stars"
			};
			
			Bitmap
			{
				image="backgrounds/textfield.png",
				x=150,
				y=10,
				scale = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "endlessstarsval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "endlessstartdiff",
				x=85,y=40,w=60,h=20,
				flags = kHAlignRight + kVAlignTop,
				label = "le_startdiff",
				
			};
			
			Bitmap
			{
				image="backgrounds/textfield.png",
				x=150,
				y=40,
				scale = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "endlessstartdiffval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "endlessmindiff",
				x=85,y=70,w=60,h=20,
				flags = kHAlignRight + kVAlignTop,
				label = "le_mindiff",
				
			};
			
			Bitmap
			{
				image="backgrounds/textfield.png",
				x=150,
				y=70,
				scale = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "endlessmindiffval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "endlesstimer",
				x=230,y=10,w=100,h=20,
				flags = kHAlignRight + kVAlignTop,
				label = "le_difftimer"
			};
			
			Bitmap
			{
				image="backgrounds/textfield.png",
				x=335,
				y=10,
				scale = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "endlesstimerval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "endlessdiffamount",
				x=230,y=40,w=100,h=20,
				flags = kHAlignRight + kVAlignTop,
				label = "le_diffdelta"
			};
			
			Bitmap
			{
				image="backgrounds/textfield.png",
				x=335,
				y=40,
				scale = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "endlessdiffdeltaval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			
			
			Text
			{
				font = EditorHeaderFont,
				name = "endlesslayout",
				x=345,y=65,w=60,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = "le_layout"
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "endlesslayoutnum",
				x=345,y=80,w=60,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = "0"
				
			};
			
			
			Button
			{
				x = 335,
				y = 80,
				name = "endlesslayoutleft",
				graphics = LeftArrowGraphics,
				type = kPush,
				scale = 0.25,
				command = 
					function() 
						IncrementLayout(-1);
					end	
			},
			
			Button
			{
				x = 385,
				y = 80,
				name = "endlesslayoutright",
				graphics = LeftArrowGraphics,
					hflip = true,
				type = kPush,
				scale = 0.25,
				command = 
					function() 
						IncrementLayout(1);
					end	
			},
			
			Text
			{
				font = EditorHeaderFont,
				name = "gridrowslabel",
				x=410,y=70,w=100,h=20,
				flags = kHAlignLeft + kVAlignTop,
				label = "le_gridrows"
			};
			
			FillWindow
			{
				x=450,
				y=70,
				w=30,
				h = 20,
				r = 0.8,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "gridrows",
					x=5,y=0,w=kMax-5,h=kMax,
					length=2					
				};
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "gridcolslabel",
				x=485,y=70,w=100,h=20,
				flags = kHAlignLeft + kVAlignTop,
				label = "le_gridcols"
			};
			
			FillWindow
			{
				x=535,
				y=70,
				w=30,
				h = 20,
				r = 0.8,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "gridcols",
					x=5,y=0,w=kMax-5,h=kMax,
					length=2					
				};
			};
			
			
			Button
			{
				x=550,
				y=5,
				font = EditorHeaderFont,
				graphics = SolidButtonGraphics,
				name="customers",
				label="le_customers",
				type = kPush,
				command=
					function()
						DoModal("scripts/leveleditor/endlessmode.lua");
					end
			},
			
		};
	}
end

function MakeMultiplayerWindow()
	return Group {
		FillWindow
		{
			x=105,
			y= 0,
			w= 590,
			h = 140,
			name = "endlessgroup",
			r = 0.75,
			g = 0.75,
			b = 0.75,
			
			BeginGroup();
			
			
			Button
			{
				x = 340,
				y = 0,
				w = 120,
				name = "mpregularshift",
				label= "le_mpregularshift",
				font = EditorHeaderFont,
				flags = kHAlignRight + kVAlignBottom,
				graphics = CheckboxButtonGraphics,
				type = kRadio,	
				xoffset = 0,
				yoffset = 0,
				scale = 0.5,
			},
			
			Button
			{
				x = 340,
				y = 30,
				w = 120,
				name = "mpendlessshift",
				label= "le_mpendlessshift",
				font = EditorHeaderFont,
				flags = kHAlignRight + kVAlignBottom,
				graphics = CheckboxButtonGraphics,
				type = kRadio,	
				xoffset = 0,
				yoffset = 0,
				scale = 0.5,
			},
			
			BeginGroup();
			
			
			Button
			{
				x = 200,
				y = 30,
				w = 130,
				name = "mpassignedtables",
				label= "le_mpassignedtables",
				font = EditorHeaderFont,
				flags = kHAlignRight + kVAlignBottom,
				graphics = CheckboxButtonGraphics,
				type = kRadio,	
				xoffset = 0,
				yoffset = 0,
				scale = 0.5,
			},
			
			Button
			{
				x = 200,
				y = 0,
				w = 130,
				name = "mpopenfloor",
				label= "le_mpopenfloor",
				font = EditorHeaderFont,
				flags = kHAlignRight + kVAlignBottom,
				graphics = CheckboxButtonGraphics,
				type = kRadio,	
				xoffset = 0,
				yoffset = 0,
				scale = 0.5,
			},
			
			BeginGroup();
			Button
  			{
  				x = 240,
  				y = 60,
  				w = 130,
  				name = "twoatatime",
  				label= "le_twoatatime",
  				font = EditorHeaderFont,
  				flags = kHAlignRight + kVAlignBottom,
  				graphics = CheckboxButtonGraphics,
  				type = kToggle,	
  				xoffset = 0,
 				yoffset = 0,
  				scale = 0.5
  			},
			
			Text
			{
				font = EditorHeaderFont,
				name = "numcustomers",
				x=0,y=10,w=50,h=20,
				flags = kHAlignRight + kVAlignTop,
				label = "le_numcustomers"
			};
			
			FillWindow
			{
				x=60,
				y=10,
				w=30,
				h = 20,
				r = 0.8,
				g = 0.5,
				b = 0.5,
			
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "numcustomersval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "endlessstartdiff",
				x=0,y=40,w=50,h=20,
				flags = kHAlignRight + kVAlignTop,
				label = "le_startdiff",
				
			};
			
			FillWindow
			{
				x=60,
				y=40,
				w=30,
				h = 20,
				r = 0.8,
				g = 0.5,
				b = 0.5,
			
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "endlessstartdiffval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "endlessmindiff",
				x=0,y=70,w=50,h=20,
				flags = kHAlignRight + kVAlignTop,
				label = "le_mindiff",
				
			};
			
			FillWindow
			{
				x=60,
				y=70,
				w=30,
				h = 20,
				r = 0.8,
				g = 0.5,
				b = 0.5,
			
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "endlessmindiffval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "endlesstimer",
				x=100,y=40,w=50,h=20,
				flags = kHAlignRight + kVAlignTop,
				label = "le_difftimer"
			};
			
			FillWindow
			{
				x=160,
				y=40,
				w=30,
				h = 20,
				r = 0.8,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "endlesstimerval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "endlessdiffamount",
				x=100,y=70,w=50,h=20,
				flags = kHAlignRight + kVAlignTop,
				label = "le_diffdelta"
			};
			
			FillWindow
			{
				x=160,
				y=70,
				w=30,
				h = 20,
				r = 0.8,
				g = 0.5,
				b = 0.5,

				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "endlessdiffdeltaval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "snackchance",
				x=100,y=10,w=50,h=20,
				flags = kHAlignRight + kVAlignTop,
				label = "le_snackchance"
			};
			
			FillWindow
			{
				x=160,
				y=10,
				w=30,
				h = 20,
				r = 0.8,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "snackchanceval",
					x=5,y=0,w=kMax-5,h=kMax,
					length=12
					
				};
			};
			
			Button
			{
				x=485,
				y=5,
				font = EditorHeaderFont,
				graphics = SolidButtonGraphics,
				name="help",
				label="le_help",
				type = kPush,
				command=
					function()
						DisplayDialog { 
							"scripts/bigok.lua", 
							body ="le_endlesshelp",
							title = ""
						};
					end
			},	
			
			Button
			{
				x=485,
				y=45,
				font = EditorHeaderFont,
				graphics = SolidButtonGraphics,
				name="customers",
				label="le_customers",
				type = kPush,
				command=
					function()
						DoModal("scripts/leveleditor/endlessmode.lua");
					end
			},
			
			Text
			{
				font = EditorHeaderFont,
				name = "endlesslayout",
				x=220,y=90,w=40,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = "le_layout"
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "endlesslayoutnum",
				x=225,y=105,w=30,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = "0"
				
			};
			
			
			Button
			{
				x = 215,
				y = 105,
				name = "endlesslayoutleft",
				graphics = LeftArrowGraphics,
				type = kPush,
				scale = 0.25,
				command = 
					function() 
						IncrementLayout(-1);
					end	
			},
			
			Button
			{
				x = 255,
				y = 105,
				name = "endlesslayoutright",
				graphics = LeftArrowGraphics,
					hflip = true,
				type = kPush,
				scale = 0.25,
				command = 
					function() 
						IncrementLayout(1);
					end	
			},
			
			Text
			{
				font = EditorHeaderFont,
				name = "mpdifficulty",
				x=290,y=90,w=60,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = "le_mpdifficulty"
			};
			
			Text
			{
				font = EditorHeaderFont,
				name = "mpdifficultyval",
				x=290,y=105,w=60,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = ""
				
			};
			
			
			Button
			{
				x = 280,
				y = 105,
				graphics = LeftArrowGraphics,
				type = kPush,
				scale = 0.25,
				command = 
					function() 
						IncrementDifficulty(-1);
					end	
			},
			
			Button
			{
				x = 350,
				y = 105,
				graphics = LeftArrowGraphics,
				hflip = true,
				type = kPush,
				scale = 0.25,
				command = 
					function() 
						IncrementDifficulty(1);
					end	
			},
			
			Text
			{
				font = EditorHeaderFont,
				name = "gridrowslabel",
				x=410,y=105,w=100,h=20,
				flags = kHAlignLeft + kVAlignTop,
				label = "le_gridrows"
			},
			
			FillWindow
			{
				x=450,
				y=105,
				w=30,
				h = 20,
				r = 0.8,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "gridrows",
					x=5,y=0,w=kMax-5,h=kMax,
					length=2					
				};
			},
			
			Text
			{
				font = EditorHeaderFont,
				name = "gridcolslabel",
				x=485,y=105,w=100,h=20,
				flags = kHAlignLeft + kVAlignTop,
				label = "le_gridcols"
			},
			
			FillWindow
			{
				x=530,
				y=105,
				w=30,
				h = 20,
				r = 0.8,
				g = 0.5,
				b = 0.5,
				
				TextEdit
				{
					font = EditorTextEditFont,
					name = "gridcols",
					x=5,y=0,w=kMax-5,h=kMax,
					length=2					
				};
			},			
		};
	}
end

function MakeGameSpecificWindows()
	if (GetCurrentGameMode() == 0) then
		return Group {
			MakeCareerWindow();
			MakeLevelTweaksWindow();
			MakeBattleModeWindow();
		}
	else
		if (GetLevelMode() == 2) then
			return Group {
				MakeMultiplayerWindow();
				MakeLevelTweaksWindow();
			}
		else
			return Group {
				MakeEndlessWindow();
			}
		end
	end	

end

MakeDialog
{
		
		LevelEditor
		{ 
			name="leveleditorwindow",
			x=0,
			y=0,
			w=800,
			h=600,
			
			Button
			{
				x=0,
				y=0,
				font = EditorHeaderFont,
				graphics = SolidButtonGraphics,
				name="showui",
				label="le_showui",
				type = kPush,
				command=
					function()
						ShowUI();
					end
			},
			
			Window
			{
				name="uiwindow",
				x=0,
				y=0,
				w=800,
				h=600,
				
			
				MakeGameSpecificWindows();			
				
				
   				FillWindow
   				{
   					x=0,
   					y= 50,
   					w= 100,
   					h = 250,
   					r = 0.75,
   					g = 0.75,
   					b = 0.75,
	   		
	   		
  					Button
  					{
  						x = 5,
  						y = 25,
  						w = 90,
  						name = "drinkstation",
  						label= "le_drink",
  						font = EditorSmallHeaderFont,
  						flags = kHAlignRight + kVAlignBottom,
  						graphics = CheckboxButtonGraphics,
  						type = kToggle,	
  						xoffset = 0,
 						yoffset = 0,
  						scale = 0.5,
  						command = 
  							function() 
  								ToggleStation(0,0);
  							end	
  					},
	   				
   					Button
   					{
   						x = 5,
   						y = 50,
   						w = 90,
   						name = "snackstation",
   						label= "le_snack",
   						font = EditorSmallHeaderFont,
   						flags = kHAlignRight + kVAlignBottom,
   						graphics = CheckboxButtonGraphics,
   						type = kToggle,	
   						xoffset = 0,
   						yoffset = 0,
   						scale = 0.5	,
   						command = 
   							function() 
  								ToggleStation(1,0);
   							end				
   					},
	   				
   					Button
   					{
   						x = 5,
   						y = 75,
   						w = 90,
   						name = "dessertstation",
   						label= "le_dessert",
   						font = EditorSmallHeaderFont,
   						flags = kHAlignRight + kVAlignBottom,
   						graphics = CheckboxButtonGraphics,
   						type = kToggle,	
   						xoffset = 0,
   						yoffset = 0,
   						scale = 0.5,
   						command = 
   							function() 
  								ToggleStation(2,0);
   							end					
   					},
	   				
   					Button
   					{
   						x = 5,
   						y = 100,
   						w = 90,
   						name = "mop",
   						label= "le_mop",
   						font = EditorSmallHeaderFont,
   						flags = kHAlignRight + kVAlignBottom,
   						graphics = CheckboxButtonGraphics,
   						type = kToggle,	
   						xoffset = 0,
   						yoffset = 0,
   						scale = 0.5	,
   						command = 
   							function() 
  								ToggleStation(3,0);
   							end				
   					},
	   				
   					Button
   					{
   						x = 5,
   						y = 125,
   						w = 90,
   						name = "highchair",
   						label= "le_highchair",
   						font = EditorSmallHeaderFont,
   						flags = kHAlignRight + kVAlignBottom,
   						graphics = CheckboxButtonGraphics,
   						type = kToggle,	
   						xoffset = 0,
   						yoffset = 0,
   						scale = 0.5	,
   						command = 
   							function() 
  								ToggleStation(4,0);
   							end				
   					},
	   				
  					Button
  					{
  						x = 5,
  						y = 150,
  						w = 90,
  						name = "phone",
  						label= "le_phone",
  						font = EditorSmallHeaderFont,
  						flags = kHAlignRight + kVAlignBottom,
  						graphics = CheckboxButtonGraphics,
  						type = kToggle,	
  						xoffset = 0,
  						yoffset = 0,
  						scale = 0.5	,
  						command = 
  							function() 
  								ToggleStation(5,0);
  							end				
  					},
	   				
  					Button
  					{
  						x = 5,
  						y = 175,
  						w = 90,
  						name = "podium",
  						label= "le_podium",
  						font = EditorSmallHeaderFont,
  						flags = kHAlignRight + kVAlignBottom,
  						graphics = CheckboxButtonGraphics,
  						type = kToggle,	
  						xoffset = 0,
  						yoffset = 0,
  						scale = 0.5	,
  						command = 
  							function() 
  								ToggleStation(6,0);
  							end				
  					},
	   				
   					Button
   					{
   						x = 5,
  						y = 200,
  						w = 90,
  						name = "bench",
  						label= "le_bench",
  						font = EditorSmallHeaderFont,
  						flags = kHAlignRight + kVAlignBottom,
  						graphics = CheckboxButtonGraphics,
  						type = kToggle,	
  						xoffset = 0,
  						yoffset = 0,
  						scale = 0.5	,
  						command = 
  							function() 
  								ToggleStation(7,0);
  							end				
  					},
	  				
  					Button
  					{
  						x = 5,
   						y = 225,
   						w = 20,
   						name = "bar1",
   						label= "",
   						font = EditorSmallHeaderFont,
   						flags = kHAlignRight + kVAlignBottom,
   						graphics = CheckboxButtonGraphics,
   						type = kToggle,	
   						xoffset = 0,
   						yoffset = 0,
   						scale = 0.5	,
   						command = 
   							function() 
 								ToggleStation(8,0);
   							end				
   					},
   					
   					Button
  					{
  						x = 25,
   						y = 225,
   						w = 20,
   						name = "bar2",
   						label= "",
   						font = EditorSmallHeaderFont,
   						flags = kHAlignRight + kVAlignBottom,
   						graphics = CheckboxButtonGraphics,
   						type = kToggle,	
   						xoffset = 0,
   						yoffset = 0,
   						scale = 0.5	,
   						command = 
   							function() 
 								ToggleStation(8,1);
   							end				
   					},
   					
   					Button
  					{
  						x = 45,
   						y = 225,
   						w = 50,
   						name = "bar3",
   						label= "le_bar3",
   						font = EditorSmallHeaderFont,
   						flags = kHAlignRight + kVAlignBottom,
   						graphics = CheckboxButtonGraphics,
   						type = kToggle,	
   						xoffset = 0,
   						yoffset = 0,
   						scale = 0.5	,
   						command = 
   							function() 
 								ToggleStation(8,2);
   							end				
   					},
   					
   					Button
  					{
  						x = 5,
   						y = 250,
   						w = 90,
   						name = "flowerstation",
   						label= "le_flowerstation",
   						font = EditorSmallHeaderFont,
   						flags = kHAlignRight + kVAlignBottom,
   						graphics = CheckboxButtonGraphics,
   						type = kToggle,	
   						xoffset = 0,
   						yoffset = 0,
   						scale = 0.5	,
   						command = 
   							function() 
 								ToggleStation(9,0);
   							end				
   					},
	   				
	   				Button
  					{
  						x = 5,
   						y = 275,
   						w = 90,
   						name = "fireplacestation",
   						label= "le_fireplacestation",
   						font = EditorSmallHeaderFont,
   						flags = kHAlignRight + kVAlignBottom,
   						graphics = CheckboxButtonGraphics,
   						type = kToggle,	
   						xoffset = 0,
   						yoffset = 0,
   						scale = 0.5	,
   						command = 
   							function() 
 								ToggleStation(10,0);
   							end				
   					},
   				};			
				
				
				
				FillWindow
				{
					x=0,
					y= 350,
					w= 100,
					h = 200,
					r = 0.75,
					g = 0.75,
					b = 0.75,
					
					BeginGroup();
			
			
					Button
					{
						x = 5,
						y = 25,
						w = 90,
						name = "movetable",
						label= "le_movetable",
						font = EditorHeaderFont,
						flags = kHAlignRight + kVAlignBottom,
						graphics = CheckboxButtonGraphics,
						type = kRadio,	
						xoffset = 0,
						yoffset = 0,
						scale = 0.5,
						on = true,
						command = 
							function() 
								SetMouseMode(0);
							end	
					},
					
					Button
					{
						x = 5,
						y = 50,
						w = 90,
						name = "deleteTable",
						label= "le_deletetable",
						font = EditorHeaderFont,
						flags = kHAlignRight + kVAlignBottom,
						graphics = CheckboxButtonGraphics,
						type = kRadio,	
						xoffset = 0,
						yoffset = 0,
						scale = 0.5	,
						command = 
							function() 
								SetMouseMode(1);
							end				
					},
					
					Button
					{
						x = 5,
						y = 75,
						w = 90,
						name = "add2top",
						label= "le_add2top",
						font = EditorHeaderFont,
						flags = kHAlignRight + kVAlignBottom,
						graphics = CheckboxButtonGraphics,
						type = kRadio,	
						xoffset = 0,
						yoffset = 0,
						scale = 0.5,
						command = 
							function() 
								SetMouseMode(2);
							end					
					},
					
					Button
					{
						x = 5,
						y = 100,
						w = 90,
						name = "add4top",
						label= "le_add4top",
						font = EditorHeaderFont,
						flags = kHAlignRight + kVAlignBottom,
						graphics = CheckboxButtonGraphics,
						type = kRadio,	
						xoffset = 0,
						yoffset = 0,
						scale = 0.5	,
						command = 
							function() 
								SetMouseMode(3);
							end				
					},
					
					Button
					{
						x = 5,
						y = 125,
						w = 90,
						name = "add6top",
						label= "le_add6top",
						font = EditorHeaderFont,
						flags = kHAlignRight + kVAlignBottom,
						graphics = CheckboxButtonGraphics,
						type = kRadio,	
						xoffset = 0,
						yoffset = 0,
						scale = 0.5	,
						command = 
							function() 
								SetMouseMode(4);
							end				
					},
					
					Button
					{
						x = 5,
						y = 150,
						w = 90,
						name = "colorseat",
						label= "le_colorseat",
						font = EditorHeaderFont,
						flags = kHAlignRight + kVAlignBottom,
						graphics = CheckboxButtonGraphics,
						type = kRadio,	
						xoffset = 0,
						yoffset = 0,
						scale = 0.5	,
						command = 
							function() 
								SetMouseMode(5);
							end				
					},
					
					Button
					{
						x = 5,
						y = 175,
						w = 90,
						name = "setzone",
						label= "le_setzone",
						font = EditorHeaderFont,
						flags = kHAlignRight + kVAlignBottom,
						graphics = CheckboxButtonGraphics,
						type = kRadio,	
						xoffset = 0,
						yoffset = 0,
						scale = 0.5	,
						command = 
							function() 
								SetMouseMode(6);
							end				
					},
					
					Button
					{
						x = 5,
						y = 200,
						w = 90,
						name = "flipbar",
						label= "le_flipbar",
						font = EditorHeaderFont,
						flags = kHAlignRight + kVAlignBottom,
						graphics = CheckboxButtonGraphics,
						type = kRadio,	
						xoffset = 0,
						yoffset = 0,
						scale = 0.5	,
						command = 
							function() 
								SetMouseMode(7);
							end				
					},
				};
				
				Button
				{
					x=670,
					y=530,
					font = EditorHeaderFont,
					graphics = SolidButtonGraphics,
					name="playlevel",
					label="le_playlevel",
					type = kPush,
					command=
						function()
							SaveLevelData();
							showTutorial = ShowMPTutorial();
							HideMPTutorial(true);
							SwapToModalSetName("scripts/game.lua");
							HideMPTutorial(showTutorial);
						end
				},
				
				
				Button
				{
					x=670,
					y=570,
					font = EditorHeaderFont,
					graphics = SolidButtonGraphics,
					name="back",
					label="back",
					type = kPush,
					command=
						function()
							SwapToModalSetName(GetMainMenuScript());
						end
				},
			};
		};
	
};